%This program is used to compute control limits for AR(1) cases when the mean function 
%and variance funcition are known.
%[h_l,h_u] contains the control limits
%k is the reference value
%m out of n is the sampling rate
%ATS_0 is the nomial ATS when the process is IC.
%N is the number of replications
%delta is the shift size
%L is the total number of time points.
function h=compute_control_limit_univ_time(h_u,h_l,k,m,n,ATS_0,N,L,phi)
avats=0;
while (avats<ATS_0*0.98||avats>ATS_0*1.02)
h=(h_u+h_l)/2;
avats=AVATS_Dtime(k,h,N,phi,m,n,L);
if avats<ATS_0*0.98
    %h_u=h_u;
    h_l=h;
elseif avats>ATS_0*1.02
    h_u=h;
   % h_l=h_l; 
else
    break
end
end